/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.app.FormattingPreferences;
import oracle.dbtools.format.SQLFormatterArb;
import oracle.dbtools.format.treetable.CodingStyleTreeBoolean;
import oracle.dbtools.format.treetable.CodingStyleTreeCategory;
import oracle.dbtools.format.treetable.CodingStyleTreeItem;
import oracle.dbtools.format.treetable.CodingStyleTreeList;
import oracle.dbtools.format.treetable.CodingStyleTreeNumber;
import oracle.dbtools.format.treetable.CodingStyleTreeTable;
import oracle.dbtools.format.treetable.CodingStyleTreeTableModel;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.FormatSQLOptionsPanel;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;

public class FormatSQLAdvancedOptions
extends FormatSQLOptionsPanel
implements ChangeListener,
TreeSelectionListener {
    public static final String VARNAME = "varname";
    private CodingStyleTreeTableModel m_model;
    private CodingStyleTreeTable m_treeTable;
    final JButton importJB = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FormatSQLAdvancedOptions.import")));
    final JButton exportJB = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FormatSQLAdvancedOptions.export")));
    final JButton resetJB = new JButton(StringUtils.stripMnemonic((String)RunnerArb.getString("LABEL_RESET")));
    private static String[] parenthesisSpacing = new String[]{Messages.getString("FormatSQLAdvancedOptions.default"), Messages.getString("FormatSQLAdvancedOptions.inside"), Messages.getString("FormatSQLAdvancedOptions.outside"), Messages.getString("FormatSQLAdvancedOptions.noSpace")};
    final int iterations = 100;
    int cnt = 0;
    public Map<String, Object> oldOptions = new HashMap<String, Object>();

    public FormatSQLAdvancedOptions() {
        this.setHelpID("f1_idedidesetsqlformat_html");
        this.m_model = this.createModel();
        this.m_model.addChangeListener(this);
        this.m_treeTable = new CodingStyleTreeTable((TreeTableModel)this.m_model){

            @Override
            public void cellChangedCallback(int n, int n2, Object object) {
                if (!FormatSQLAdvancedOptions.this.preview.isSelected()) {
                    return;
                }
                TreePath treePath = FormatSQLAdvancedOptions.this.m_treeTable.getTree().getPathForRow(n);
                CodingStyleTreeItem codingStyleTreeItem = (CodingStyleTreeItem)treePath.getLastPathComponent();
                FormatSQLAdvancedOptions.this.saveSettingsToItem(codingStyleTreeItem, object);
                FormatSQLAdvancedOptions.this.updatePreview();
            }

            public void paint(Graphics graphics) {
                super.paintComponent(graphics);
                if (FormatSQLAdvancedOptions.this.cnt == 0 || FormatSQLAdvancedOptions.this.cnt >= 100) {
                    return;
                }
                for (int i = 0; i < FormatSQLAdvancedOptions.this.m_treeTable.getRowCount(); ++i) {
                    TreePath treePath = FormatSQLAdvancedOptions.this.m_treeTable.getTree().getPathForRow(i);
                    CodingStyleTreeItem codingStyleTreeItem = (CodingStyleTreeItem)treePath.getLastPathComponent();
                    if (!FormatSQLAdvancedOptions.this.isChanged(codingStyleTreeItem.getPropertyName())) continue;
                    Rectangle rectangle = this.getCellRect(i, 1, false);
                    float f = 0.8f;
                    float f2 = f / 100.0f;
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f - f2 * (float)FormatSQLAdvancedOptions.this.cnt + 0.1f);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setComposite(alphaComposite);
                    GradientPaint gradientPaint = new GradientPaint(rectangle.x, rectangle.y, Color.GREEN, rectangle.x + rectangle.width, rectangle.y + rectangle.height, Color.GRAY);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        };
        JTree jTree = this.m_treeTable.getTree();
        this.m_model.setTree(jTree);
        jTree.addTreeSelectionListener(this);
        jTree.expandRow(3);
        jTree.expandRow(2);
        jTree.expandRow(1);
        jTree.expandRow(0);
        jTree.setSelectionPath(jTree.getPathForRow(0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.importJB.addActionListener(this);
        jPanel.add(this.importJB);
        this.exportJB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(50));
        jPanel.add(this.exportJB);
        this.resetJB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(50));
        jPanel.add(this.resetJB);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Last");
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.m_treeTable));
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        Color color = this.m_treeTable.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.editorChoosePreviewDetectPanel, "North");
        jPanel3.add((Component)new JScrollPane((Component)this.editor), "Center");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(jPanel2);
        jSplitPane.setRightComponent(jPanel3);
        this.setLayout(new BorderLayout());
        this.add(jSplitPane, "Center");
        this.editor.removeKeyListener(this.editorKeyListener);
        this.editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (FormatSQLAdvancedOptions.this.detect.isSelected()) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '\u0016' || keyEvent.getKeyChar() == '\n') {
                        String string = FormatSQLAdvancedOptions.this.editor.getText();
                        List list = LexerToken.parse((String)string);
                        if (list.size() < 5) {
                            return;
                        }
                        FormattingPreferences.debug = "true".equals(HiddenParameters.parameters.get("debugFormatPreferences"));
                        FormatSQLAdvancedOptions.this.oldOptions = new HashMap<String, Object>();
                        FormatSQLAdvancedOptions.this.oldOptions.putAll(CustomFormat.getInstance().options);
                        try {
                            FormattingPreferences formattingPreferences = new FormattingPreferences();
                            formattingPreferences.format = CustomFormat.getInstance();
                            formattingPreferences.invokeAllGuessMethods(string);
                            CustomFormat.getInstance().setOptions(formattingPreferences.format.options);
                            System.out.println(CustomFormat.getInstance().options.get("identSpaces").toString());
                            FormatSQLAdvancedOptions.this.refreshTree(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return;
                }
                if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '\u0016') {
                    FormatSQLAdvancedOptions.this.updatePreview();
                }
                if (keyEvent.getKeyChar() == '\n') {
                    FormatSQLAdvancedOptions.this.updatePreview();
                }
            }
        });
    }

    private boolean isChanged(String string) {
        Object object = this.oldOptions.get(string);
        Object v = CustomFormat.getInstance().options.get(string);
        if (object == null || v == null) {
            return false;
        }
        boolean bl = !object.toString().equals(v.toString());
        return bl;
    }

    private CodingStyleTreeTableModel createModel() {
        CodingStyleTreeTableModel codingStyleTreeTableModel = new CodingStyleTreeTableModel(null);
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ROOT"), "f1_idedidesetsqlformat_html", FormatSQLAdvancedOptions.getSample());
        codingStyleTreeTableModel.setRoot(codingStyleTreeCategory);
        codingStyleTreeCategory.addChild(this.general(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.alignment(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.indentation(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.linebreaks(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.whiteSpace(codingStyleTreeTableModel));
        return codingStyleTreeTableModel;
    }

    private CodingStyleTreeCategory general(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = FormatSQLAdvancedOptions.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, Messages.getString("FormatSQLAdvancedOptions.general"), "f1_idedidesetsqlformat_html", string);
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("kwCase", Messages.getString("FormatSQLOptionsPanel.kwCase"), string, this.caseConversion));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("idCase", Messages.getString("FormatSQLOptionsPanel.idCase"), string, this.caseConversion));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("singleLineComments", Messages.getString("FormatSQLAdvancedOptions.singleLineComments"), string, this.singleLineCommentsOptions));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory alignment(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = FormatSQLAdvancedOptions.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGNMENT"), "f1_idedidesetsqlformat_html", string);
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignTabColAliases", Messages.getString("FormatSQLAdvancedOptions.alignTabColAliases"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignTypeDecl", Messages.getString("FormatSQLAdvancedOptions.alignTypeDecl"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignNamedArgs", Messages.getString("FormatSQLAdvancedOptions.alignNamedArgs"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignAssignments", Messages.getString("FormatSQLAdvancedOptions.alignAssignments"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignEquality", Messages.getString("FormatSQLAdvancedOptions.alignEquality"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignRight", Messages.getString("FormatSQLAdvancedOptions.alignKeywords"), string));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory indentation(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = FormatSQLAdvancedOptions.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_INDENTATION"), "f1_idedidesetsqlformat_html", string);
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("identSpaces", Messages.getString("FormatSQLOptionsPanel.indentSpaces"), string, 1, 40));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("useTab", Messages.getString("FormatSQLAdvancedOptions.useTab"), string, this.tabSpacesItems));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory linebreaks(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = FormatSQLAdvancedOptions.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_LINE_BREAKS"), "f1_idedidesetsqlformat_html", string);
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("breaksComma", Messages.getString("FormatSQLAdvancedOptions.onComma"), string, this.beforeAfterCommaItems));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("commasPerLine", Messages.getString("FormatSQLAdvancedOptions.commasPerLine"), string, 1, 100));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("breaksConcat", Messages.getString("FormatSQLAdvancedOptions.onConcat"), string, this.beforeAfterConcatItems));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("breaksAroundLogicalConjunctions", Messages.getString("FormatSQLAdvancedOptions.breaksAroundLogicalConjunctions"), string, this.afterLogicalConnectorItems));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakAnsiiJoin", Messages.getString("FormatSQLAdvancedOptions.breakOnAnsiiJoins"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakParenCondition", Messages.getString("FormatSQLAdvancedOptions.breakParenCondition"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakOnSubqueries", Messages.getString("FormatSQLAdvancedOptions.breakOnSubqueries"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("maxCharLineSize", Messages.getString("FormatSQLAdvancedOptions.maxCharLineSize"), string, 60, 10000));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("forceLinebreaksBeforeComment", Messages.getString("FormatSQLAdvancedOptions.forceLinebreaksBeforeComment"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("extraLinesAfterSignificantStatements", Messages.getString("FormatSQLAdvancedOptions.extraLinesAfterSignificantStatements"), string, this.isolateStatementsItems));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breaksAfterSelect", "SELECT/FROM/WHERE", string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("flowControl", Messages.getString("FormatSQLAdvancedOptions.flowControl"), string, this.flowControl));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory whiteSpace(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = FormatSQLAdvancedOptions.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_WHITE_SPACE_2"), "f1_idedidesetsqlformat_html", string);
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("spaceAroundOperators", Messages.getString("FormatSQLAdvancedOptions.spaceAroundOperators"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("spaceAfterCommas", Messages.getString("FormatSQLAdvancedOptions.spaceAfterCommas"), string));
        Objects.requireNonNull(CustomFormat.getInstance());
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("spaceAroundBrackets", Messages.getString("FormatSQLAdvancedOptions.spaceAroundBrackets"), string, parenthesisSpacing));
        return codingStyleTreeCategory;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.preview.isSelected()) {
            return;
        }
        this.updatePreview();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.preview.isSelected()) {
            return;
        }
        this.updatePreview();
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        FormatSQLAdvancedOptions.loadOptions();
        this.refreshTree(false);
        if (this.preview.isSelected()) {
            this.updatePreview();
        }
    }

    private void refreshTree(boolean bl) {
        this.loadSettingsFromCategory((CodingStyleTreeCategory)this.m_model.getRoot());
        if (bl) {
            new Thread(){

                @Override
                public void run() {
                    FormatSQLAdvancedOptions.this.cnt = 0;
                    while (FormatSQLAdvancedOptions.this.cnt <= 100) {
                        try {
                            Thread.sleep(100L);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FormatSQLAdvancedOptions.this.m_treeTable.repaint();
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++FormatSQLAdvancedOptions.this.cnt;
                    }
                }
            }.start();
        }
    }

    private void loadSettingsFromCategory(CodingStyleTreeCategory codingStyleTreeCategory) {
        int[] nArray = new int[codingStyleTreeCategory.getChildCount()];
        for (int i = 0; i < codingStyleTreeCategory.getChildCount(); ++i) {
            Object object;
            nArray[i] = i;
            CodingStyleTreeItem codingStyleTreeItem = codingStyleTreeCategory.getChild(i);
            if (codingStyleTreeItem instanceof CodingStyleTreeCategory) {
                object = (CodingStyleTreeCategory)codingStyleTreeItem;
                this.loadSettingsFromCategory((CodingStyleTreeCategory)object);
                continue;
            }
            object = codingStyleTreeItem.getPropertyName();
            if (!CustomFormat.getInstance().options.containsKey(object)) continue;
            try {
                Object object2 = this.persisted2displayed((String)object);
                codingStyleTreeItem.setValue(object2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error setting " + (String)object + ":  " + exception.getMessage());
            }
        }
        this.m_model.itemsChanged(codingStyleTreeCategory, nArray);
    }

    @Override
    public void onExit(TraversableContext traversableContext) {
        this.saveSettingsToCategory((CodingStyleTreeCategory)this.m_model.getRoot());
        FormatSQLAdvancedOptions.saveOptions();
        TableCellEditor tableCellEditor = this.m_treeTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void saveSettingsToCategory(CodingStyleTreeCategory codingStyleTreeCategory) {
        for (int i = 0; i < codingStyleTreeCategory.getChildCount(); ++i) {
            CodingStyleTreeItem codingStyleTreeItem = codingStyleTreeCategory.getChild(i);
            if (codingStyleTreeItem instanceof CodingStyleTreeCategory) {
                CodingStyleTreeCategory codingStyleTreeCategory2 = (CodingStyleTreeCategory)codingStyleTreeItem;
                this.saveSettingsToCategory(codingStyleTreeCategory2);
                continue;
            }
            this.saveSettingsToItem(codingStyleTreeItem, null);
        }
    }

    private void saveSettingsToItem(CodingStyleTreeItem codingStyleTreeItem, Object object) {
        String string = codingStyleTreeItem.getPropertyName();
        if (CustomFormat.getInstance().options.containsKey(string)) {
            try {
                if (object == null) {
                    object = codingStyleTreeItem.getValue();
                } else {
                    codingStyleTreeItem.setValue(object);
                }
                if (codingStyleTreeItem instanceof CodingStyleTreeList) {
                    CodingStyleTreeList codingStyleTreeList = (CodingStyleTreeList)codingStyleTreeItem;
                    object = codingStyleTreeList.getValues()[(Integer)object];
                }
                this.displayed2persisted(string, object);
            }
            catch (Exception exception) {
                System.err.println("Error persisting " + string + ":  " + exception.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.importExportProfile(actionEvent.getSource());
    }

    private URL lastImportExportURL() {
        DBConfig dBConfig = DBConfig.getInstance();
        try {
            String string = dBConfig.getString("FORMAT_PROFILE_URL");
            if (!"N/A".equals(string)) {
                return new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return null;
    }

    private void importExportProfile(Object object) {
        if (object == this.resetJB) {
            CustomFormat.getInstance().setDefaultOptions();
            this.refreshTree(true);
            if (this.preview.isSelected()) {
                this.updatePreview();
            }
            return;
        }
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(SQLFormatterArb.getString("PROFILE_FILTER_NAME"), ".xml");
        uRLFileChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        if (this.lastImportExportURL() != null) {
            uRLFileChooser.setSelectedURL(this.lastImportExportURL());
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                uRLFileChooser.setSelectedURL(uRL);
            }
        }
        int n = -1;
        n = object == this.importJB ? uRLFileChooser.showOpenDialog((Component)((Object)this), SQLFormatterArb.getString("IMPORT_PROFILE_TITLE")) : uRLFileChooser.showSaveDialog((Component)((Object)this), SQLFormatterArb.getString("EXPORT_PROFILE_TITLE"));
        if (n == 0) {
            URL uRL = uRLFileChooser.getSelectedURL();
            if (object == this.importJB) {
                FormatSQLAdvancedOptions.importOptions(uRL);
                this.refreshTree(true);
                if (this.preview.isSelected()) {
                    this.updatePreview();
                }
            } else if (this.checkExistingFile(uRL)) {
                FormatSQLAdvancedOptions.exportOptions(uRL);
            }
            DBConfig dBConfig = DBConfig.getInstance();
            dBConfig.putString("FORMAT_PROFILE_URL", uRL.toString());
        }
    }

    private URL getUserHomeDirectory() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)uRL) ? uRL : null;
    }

    private boolean checkExistingFile(URL uRL) {
        if (URLFileSystem.exists((URL)uRL)) {
            String string = SQLFormatterArb.format("EXPORT_OVERWRITE_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL));
            String string2 = SQLFormatterArb.getString("EXPORT_OVERWRITE_WARNING_TITLE");
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, string2, 2);
            return n == 0;
        }
        return true;
    }
}

