/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectConnectionException;
import oracle.dbtools.extension.project.core.exceptions.ProjectExistsException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.liquibase.core.CommandGenerator;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.Logger;

public class ProjectUtils {
    static void writeln(ScriptRunnerContext ctx, String msg, boolean verbose) {
        if (verbose) {
            try {
                ctx.writeln(msg);
                ctx.getOutputStream().getMainStream().flush();
            }
            catch (Exception e) {
                System.out.println(msg);
            }
        }
    }

    public static boolean ignoreCaseContains(List<String> theList, String searchStr) {
        for (String s : theList) {
            if (!searchStr.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashMap<String, Object> getMatchingSettings(List<String> theList, String searchStr) {
        LinkedHashMap<String, Object> matchingSettings = new LinkedHashMap<String, Object>();
        for (String s : theList) {
            if (!s.contains(searchStr)) continue;
            matchingSettings.put(s, ProjectSettings.getUserConfigMap().get(s));
        }
        return matchingSettings;
    }

    public static void writeInfo(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("INFO: " + msg);
    }

    public static void writeError(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("ERROR: " + msg);
    }

    public static void writeWarn(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("WARN: " + msg);
    }

    public static void writeDebug(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("DEBUG: " + msg);
    }

    private static Connection connect(ScriptRunnerContext ctx, String connName) throws IOException, ProjectConnectionException {
        try (StringReader reader = new StringReader("connect -name " + connName);){
            ScriptParser parser = new ScriptParser((Reader)reader);
            ISQLCommand sqlCommand = parser.next();
            if (sqlCommand != null) {
                new ConnectCommand().handleEvent(ctx.getCurrentConnection(), ctx, sqlCommand);
                Connection connection = ctx.getCurrentConnection();
                return connection;
            }
        }
        throw new ProjectConnectionException(ProjectMessages.getString("PROJECT_CONNECT_ERROR"));
    }

    public static Connection getConnection(ScriptRunnerContext ctx) {
        return ProjectUtils.getConnection(ctx, true);
    }

    public static Connection getConnection(ScriptRunnerContext ctx, boolean verbose) {
        Connection activeConnection = ctx.getCurrentConnection();
        if (activeConnection == null) {
            String connectionIsNull = "ctx.getCurrentConnection()==null";
            String connectionName = ProjectSettings.getSettingAsString("sqlcl.connectionName");
            if (connectionName != null && !connectionName.isEmpty()) {
                try {
                    ProjectUtils.writeln(ctx, MessageFormat.format(ProjectMessages.getString("STORED_CONNECTION"), connectionName), verbose);
                    activeConnection = ProjectUtils.connect(ctx, connectionName);
                    if (ctx.getCurrentConnection() == null) {
                        throw new Exception("ctx.getCurrentConnection()==null");
                    }
                }
                catch (Exception e) {
                    ProjectUtils.writeln(ctx, MessageFormat.format(ProjectMessages.getString("STORED_CONNECTION_FAILED"), connectionName), true);
                    if (!"ctx.getCurrentConnection()==null".equals(e.getMessage())) {
                        ProjectUtils.writeln(ctx, e.getLocalizedMessage(), true);
                    }
                    ProjectUtils.restoreConnection(ctx, activeConnection);
                    return activeConnection;
                }
            }
            if (ctx.getCurrentConnection() == null) {
                ProjectUtils.writeln(ctx, ProjectMessages.getString("NO_CONNECTION"), true);
                ProjectUtils.restoreConnection(ctx, activeConnection);
                return activeConnection;
            }
        } else {
            Object url = "";
            String user = "";
            try {
                url = activeConnection.getMetaData().getURL();
                user = activeConnection.getSchema();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String prefix = "jdbc:oracle:thin:@";
            if (((String)url).startsWith("jdbc:oracle:thin:@")) {
                url = ((String)url).substring("jdbc:oracle:thin:@".length());
            }
            url = (String)url + " " + user;
            System.out.println(MessageFormat.format(ProjectMessages.getString("CURRENT_CONNECTION"), url));
        }
        return activeConnection;
    }

    private static void restoreConnection(ScriptRunnerContext ctx, Connection old) {
    }

    public static String removeIllegalCharacters(String name, boolean singleSpaces, boolean replaceWhitespace) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String safe = name.trim();
        safe = safe.replaceAll("[\\/|\\\\|\\*|\\:|\\||\"|'|\\<|\\>|\\{|\\}|\\?|\\%|@]", "");
        if (singleSpaces) {
            safe = safe.replaceAll(" {2,}", " ");
        }
        if (replaceWhitespace) {
            safe = safe.replaceAll("\\s+", "_");
        }
        return safe.trim();
    }

    public static Path getProjectRootFolder() throws ProjectExistsException {
        Path root = ProjectConfig.getCurrentWorkingProjectRoot();
        if (root == null) {
            throw new ProjectExistsException(ProjectMessages.getString("NOT_PROJECT_ERR"));
        }
        return root;
    }

    public static void displayArgs(ScriptRunnerContext _ctx, ParsedCommand _sqlclCommand) {
        if (!_sqlclCommand.isFlagSet((Id)ProjectOptions.Options.DEBUG)) {
            return;
        }
        try {
            List options = _sqlclCommand.getType().getOptions();
            if (options.isEmpty()) {
                return;
            }
            _ctx.write("-----  DISPLAY ARGUMENTS  -----" + System.lineSeparator() + System.lineSeparator());
            for (Option option : options) {
                String val = (String)ProjectUtils.getOptionValue(option.getId(), _sqlclCommand);
                if (val == null) {
                    val = "null";
                }
                String req = option.isRequired() ? "REQUIRED  " : "";
                _ctx.write("  " + req + option.getName() + ":" + ProjectUtils.pad(15 - (option.getName().length() + req.length())) + val + System.lineSeparator());
            }
            _ctx.write(System.lineSeparator() + "-----  END ARGUMENTS -----" + System.lineSeparator() + System.lineSeparator());
        }
        catch (RuntimeException e) {
            Logger.warn(CommandGenerator.class, (Throwable)e);
        }
    }

    private static <T> T getOptionValue(Id optionId, ParsedCommand _sqlclCommand) {
        try {
            if (null != _sqlclCommand.getOptionValue(optionId)) {
                return (T)_sqlclCommand.getOptionValue(optionId);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String pad(int howMany) {
        return " ".repeat(Math.max(0, howMany));
    }

    public static void printTable(List<List<String>> table) {
        if (table == null || table.isEmpty() || table.get(0) == null || table.get(0).isEmpty()) {
            return;
        }
        ScriptRunnerContext context = ProjectConfig.getCurrentContext();
        int terminalWidth = context.getSQLPlusConsoleReader().getWidth();
        int columns = table.get(0).size();
        int maxColumnWidth = (terminalWidth - (columns + 2) - columns * 2) / columns;
        List<Integer> maxWidths = ProjectUtils.longestValPerCol(table);
        int wholeWidth = maxWidths.stream().mapToInt(width -> Math.min(width, maxColumnWidth) + 3).sum();
        String headerSeparator = " +" + "=".repeat(wholeWidth - 1) + "+";
        String rowSeparator = " +" + "-".repeat(wholeWidth - 1) + "+";
        context.writeln(headerSeparator);
        for (int rowIndex = 0; rowIndex < table.size(); ++rowIndex) {
            List<String> row = table.get(rowIndex);
            ProjectUtils.printRow(row, maxWidths, maxColumnWidth);
            if (rowIndex == 0) {
                context.writeln(headerSeparator);
                continue;
            }
            context.writeln(rowSeparator);
        }
    }

    private static void printRow(List<String> row, List<Integer> maxWidths, int maxColumnWidth) {
        int maxLines = 1;
        ArrayList<String[]> splitRows = new ArrayList<String[]>();
        for (int i = 0; i < row.size(); ++i) {
            String col = row.get(i);
            String[] splitCol = ProjectUtils.splitCell(col, Math.min(maxWidths.get(i), maxColumnWidth));
            maxLines = Math.max(maxLines, splitCol.length);
            splitRows.add(splitCol);
        }
        for (int line = 0; line < maxLines; ++line) {
            ScriptRunnerContext context = ProjectConfig.getCurrentContext();
            for (int i = 0; i < row.size(); ++i) {
                String[] splitCol = (String[])splitRows.get(i);
                String cellLine = line < splitCol.length ? splitCol[line] : "";
                context.write(" | " + ProjectUtils.padRight(cellLine, Math.min(maxWidths.get(i), maxColumnWidth)));
            }
            context.writeln(" |");
        }
    }

    private static String[] splitCell(String cell, int width) {
        if (cell == null) {
            cell = "";
        }
        int numLines = (int)Math.ceil((double)cell.length() / (double)width);
        String[] lines = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            int start = i * width;
            int end = Math.min(start + width, cell.length());
            lines[i] = cell.substring(start, end);
        }
        return lines;
    }

    public static List<Integer> longestValPerCol(List<List<String>> table) {
        if (table == null || table.isEmpty()) {
            return Collections.emptyList();
        }
        int columnCount = table.get(0).size();
        ArrayList<Integer> maxWidths = new ArrayList<Integer>(Collections.nCopies(columnCount, 0));
        for (List<String> row : table) {
            if (row == null || row.isEmpty()) continue;
            for (int j = 0; j < row.size(); ++j) {
                String col = row.get(j);
                if (col == null) {
                    col = "";
                }
                maxWidths.set(j, Math.max((Integer)maxWidths.get(j), col.length()));
            }
        }
        return maxWidths;
    }

    private static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    public static String checkValidSchemas(String[] schs, ScriptRunnerContext ctx) {
        String query = "select count(*) from all_users where username = :schema";
        Object validSchemas = "";
        for (String usch : schs) {
            HashMap<String, String> binds = new HashMap<String, String>();
            DBUtil dbUtil = DBUtil.getInstance((Connection)ctx.getCurrentConnection());
            binds.put("schema", usch.toUpperCase());
            String count = dbUtil.executeOracleReturnOneCol(query, binds);
            if (Integer.parseInt(count) <= 0) continue;
            validSchemas = (String)validSchemas + usch + ",";
        }
        if (!((String)validSchemas).isEmpty()) {
            validSchemas = ((String)validSchemas).substring(0, ((String)validSchemas).lastIndexOf(","));
        }
        return validSchemas;
    }
}

