/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectNotIdentifiedException;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;

public class ChangeLogSorter {
    public static String sortChangelog(String log) throws IOException, ProjectNotIdentifiedException, ProjectSettingsException {
        StringBuilder output = new StringBuilder();
        LinkedList rows = new LinkedList();
        rows.push(new HashMap());
        String previousType = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(log));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("<!--BEGIN")) {
                    rows.push(new HashMap());
                    output.append(line);
                    output.append("\n");
                } else if (line.startsWith("<include")) {
                    String[] vals = line.split(" ");
                    String type = vals[1].split(Pattern.quote(File.separator))[1].toUpperCase();
                    if (ChangeLogSorter.firstRowIsCustom(previousType, type)) {
                        output.append(line).append("\n");
                    } else {
                        HashMap curRow;
                        String string = previousType = !type.equals(previousType) && type.equals("_CUSTOM") ? previousType : type;
                        if (type.equals("_CUSTOM")) {
                            type = previousType;
                        }
                        if ((curRow = (HashMap)rows.peek()) != null) {
                            if (!curRow.containsKey(type)) {
                                curRow.put(type, new ArrayList());
                            }
                            ((ArrayList)curRow.get(type)).add(line);
                        }
                    }
                } else if (line.startsWith("<!--END")) {
                    HashMap curRow = (HashMap)rows.peek();
                    if (curRow != null) {
                        output.append(ChangeLogSorter.sortRows(curRow));
                        output.append(line);
                        output.append("\n");
                        rows.pop();
                    }
                } else {
                    output.append(line);
                    output.append("\n");
                }
                line = reader.readLine();
            }
        }
        return output.toString();
    }

    private static boolean firstRowIsCustom(String previousType, String type) {
        return previousType == null && type.equals("_CUSTOM");
    }

    private static String sortRows(HashMap<String, ArrayList<String>> row) throws ProjectNotIdentifiedException, ProjectSettingsException {
        ArrayList<String> records;
        if (row.isEmpty()) {
            return "";
        }
        List<String> orderAll = ProjectSettings.getSettingAsList("stage.changeLogSortOrder");
        StringBuilder result = new StringBuilder();
        for (String orderType : orderAll) {
            if (row.containsKey(orderType)) {
                records = row.get(orderType);
                for (String record : records) {
                    result.append(record);
                    result.append("\n");
                }
            }
            row.remove(orderType);
        }
        if (!row.isEmpty()) {
            ProjectConfig.getCurrentContext().writeln(StageMessages.format("UNSORTED_ROWS", String.join((CharSequence)",\n", row.keySet())));
            for (String key : row.keySet()) {
                records = row.get(key);
                for (String record : records) {
                    result.append(record);
                    result.append("\n");
                }
            }
        }
        return result.toString();
    }
}

