/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.objectclasses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import org.apache.commons.io.FileUtils;

public class SrcSnapShot {
    private static String pattern = "^--\\s* sqlcl_snapshot\\s*(\\{.*\\})";
    private static Pattern r = Pattern.compile(pattern, 8);
    String hash;
    String type;
    String name;
    String schemaName;
    String sxml;

    public static SrcSnapShot loadSnapShot(File file) throws IOException {
        return SrcSnapShot.loadSnapShot(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
    }

    public static SrcSnapShot loadSnapShot(String data) throws JsonProcessingException {
        Matcher m = r.matcher(data);
        if (m.find()) {
            String json = m.group(1);
            return (SrcSnapShot)ProjectSettings.getMapper().readValue(json, SrcSnapShot.class);
        }
        return null;
    }

    @Generated
    public SrcSnapShot() {
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getSxml() {
        return this.sxml;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setSxml(String sxml) {
        this.sxml = sxml;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SrcSnapShot)) {
            return false;
        }
        SrcSnapShot other = (SrcSnapShot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$sxml = this.getSxml();
        String other$sxml = other.getSxml();
        return !(this$sxml == null ? other$sxml != null : !this$sxml.equals(other$sxml));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SrcSnapShot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $sxml = this.getSxml();
        result = result * 59 + ($sxml == null ? 43 : $sxml.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SrcSnapShot(hash=" + this.getHash() + ", type=" + this.getType() + ", name=" + this.getName() + ", schemaName=" + this.getSchemaName() + ", sxml=" + this.getSxml() + ")";
    }
}

