/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.secret;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.plusplus.secret.SecretCacheException;
import oracle.dbtools.plusplus.secret.SecretResources;

public class SecretCache {
    private final Map<String, TextSecret> secretMap = new HashMap<String, TextSecret>();

    public static SecretCache getInstance() {
        return Holder.CACHE;
    }

    private SecretCache() {
    }

    public TextSecret findSecret(String name) {
        TextSecret secret = this.secretMap.get(name);
        return secret != null ? secret : TextSecret.none();
    }

    public void removeSecret(String name) throws SecretCacheException {
        TextSecret secret = this.secretMap.remove(name);
        if (secret == null) {
            throw SecretCacheException.of(SecretResources.format("ERROR_SECRET_NOT_FOUND", name));
        }
        secret.close();
    }

    public Collection<String> listSecrets() {
        return this.secretMap.keySet();
    }

    public TextSecret addSecret(String name, char[] secret) throws SecretCacheException {
        if (this.secretMap.containsKey(name)) {
            throw SecretCacheException.of(SecretResources.format("ERROR_DUPLICATE_NAME", name));
        }
        TextSecret textSecret = Secrets.instance().of(secret, true);
        this.secretMap.put(name, textSecret);
        return textSecret;
    }

    private static class Holder {
        private static final SecretCache CACHE = new SecretCache();

        private Holder() {
        }
    }
}

