/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.ora.CloudSupport;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;
import oracle.dbtools.util.InputOutputStreams;
import oracle.dbtools.util.URIUtils;

public class CloudConverterFactory
implements ConnectionsConverterFactory {
    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && "CLOUD".equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging) {
        return new CloudConverter(provider, logging);
    }

    private static class CloudConverter
    extends BaseOracleConverter {
        private final String configFile;
        private final Path archiveFile;

        public CloudConverter(DatabaseProvider provider, MessageLogger logging) {
            super(provider, logging);
            this.configFile = this.definition.getProperty("sqldev.cloud.configfile");
            this.archiveFile = this.configFile != null ? Paths.get(URIUtils.newURI(this.configFile)) : null;
        }

        @Override
        protected String processConnectionSpec() throws IOException {
            if (this.configFile == null) {
                throw new IOException("Missing archive file");
            }
            if (!Files.isRegularFile(this.archiveFile, new LinkOption[0])) {
                throw new IOException("Cannot find cloud archive file " + this.archiveFile);
            }
            this.addDBToolsProperty("type", "ORACLE_DATABASE");
            return this.processCustomURL();
        }

        @Override
        protected void processAdvancedProperties() {
            String proxymode = this.definition.getProperty("sqldev.http.proxymode");
            if (CloudSupport.ProxyMode.CUSTOM.name().equals(proxymode)) {
                String proxyHost = this.definition.getProperty("sqldev.http.proxy.host");
                String proxyPort = this.definition.getProperty("sqldev.http.proxy.port");
                if (ModelUtil.hasLength(proxyHost) && ModelUtil.hasLength(proxyPort)) {
                    this.addAdvancedProperty("oracle.net.httpsProxyHost", proxyHost.trim());
                    this.addAdvancedProperty("oracle.net.httpsProxyPort", proxyPort.trim());
                }
            }
            super.processAdvancedProperties();
        }

        @Override
        protected void output(ConnectionStorage store) throws IOException {
            HashSet<String> unProcessedFiles = new HashSet<String>();
            unProcessedFiles.add("dbtools.properties");
            unProcessedFiles.add("ojdbc.properties");
            try (ZipInputStream in = new ZipInputStream(Files.newInputStream(this.archiveFile, new OpenOption[0]));){
                ZipEntry entry = in.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    Path path = Path.of(name, new String[0]);
                    if (entry.isDirectory()) {
                        store.createSubdirectory(this.identifier, path);
                    } else {
                        String fname;
                        InputStream contents = InputOutputStreams.instance().uncloseable(in);
                        switch (fname = path.getFileName().toString()) {
                            case "ojdbc.properties": {
                                store.storeObject(this.identifier, name, (Object)in, (is, out) -> {
                                    InputOutputStreams.instance().copy((InputStream)is, out);
                                    this.outputAdvancedProperties(out);
                                });
                                unProcessedFiles.remove("ojdbc.properties");
                                break;
                            }
                            case "dbtools.properties": {
                                store.storeObject(this.identifier, name, (Object)in, (is, out) -> {
                                    InputOutputStreams.instance().copy((InputStream)is, out);
                                    this.outputDBToolsProperties(out);
                                });
                                unProcessedFiles.remove("dbtools.properties");
                                break;
                            }
                            default: {
                                store.storeObject(this.identifier, name, (Object)contents, (data, out) -> InputOutputStreams.instance().copy((InputStream)data, out));
                            }
                        }
                    }
                    entry = in.getNextEntry();
                }
            }
            if (unProcessedFiles.contains("dbtools.properties")) {
                this.writeDBToolsProperties(store, this.identifier);
            }
            if (unProcessedFiles.contains("ojdbc.properties")) {
                this.writeAdvancedProperties(store, this.identifier);
            }
            this.writeWallet(store, this.identifier);
        }
    }
}

