/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.api.Connections;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.ConnectionDetailDisplay;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.ConnectionTester;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.imp.ImporterFactory;
import oracle.dbtools.plusplus.connections.db.storage.SQLclConnectionCloner;
import oracle.dbtools.plusplus.secret.SecretCache;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

@Restricted(level=Restricted.Level.R4)
public class ConnectionStoreCommand
extends CommandListener
implements IHelp {
    private final Map<Type, SubCommand> subcommands = new HashMap<Type, SubCommand>();

    public ConnectionStoreCommand() {
        this.subcommands.put(ConnectionStoreOptions.IMPORT_COMMAND, this::handleImportCommand);
        this.subcommands.put(ConnectionStoreOptions.LIST_COMMAND, this::handleListCommand);
        this.subcommands.put(ConnectionStoreOptions.SHOW_COMMAND, this::handleShowCommand);
        this.subcommands.put(ConnectionStoreOptions.TEST_COMMAND, this::handleTestCommand);
        this.subcommands.put(ConnectionStoreOptions.CLONE_COMMAND, this::handleCloneCommand);
    }

    @Override
    public String getCommand() {
        return ConnectionStoreOptions.Symbol.CONNMGR.name();
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        HelpPagesBuilder helpPagesBuilder = new HelpPagesBuilder(ctx.getEnvironment()).addHelpContainerFor(this).addPages(new CommandPageAssemblers(ConnectionStoreOptions.COMMAND, new Type[0]));
        return helpPagesBuilder.build().get(pagePath);
    }

    private String createHelpPath(String root, String ... elements) {
        StringBuilder sb = new StringBuilder(root);
        for (String element : elements) {
            sb.append('/').append(element);
        }
        return sb.toString();
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public Type getParserType() {
        return ConnectionStoreOptions.COMMAND;
    }

    private void displayHelp(CommandContext ctx, String pagePath) {
        Optional<String> optionalHelp = this.getHelp(ctx.getScriptRunnerContext(), pagePath);
        optionalHelp.ifPresent(arg_0 -> ((MessageLogger)ctx.getMessageLogger()).logUserMessage(arg_0));
    }

    private SubCommand getSubcommand(Type command) {
        return this.subcommands.get(command);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.startsWithAlias(cmd.getSql(), new String[]{ConnectionStoreOptions.Symbol.CONNMGR.name(), "CM"})) {
            return false;
        }
        CommandContext cmdCtx = CommandContext.of(ctx, ConnectionStoreCommand.class);
        ArrayList errorMessages = new ArrayList();
        Parser parser = new Parser(ConnectionStoreOptions.COMMAND, ctx.getEnvironment());
        Optional<ParsedCommand> optional = parser.parse(SQLPLUSUtil.cleanCommand(cmd).getSql(), errorMessages::add);
        if (optional.isPresent()) {
            ParsedCommand parsedCommand = optional.get();
            Type type = parsedCommand.getType();
            SubCommand subCommand = this.getSubcommand(type);
            if (subCommand == null) {
                this.displayHelp(cmdCtx, ConnectionStoreOptions.Symbol.CONNMGR.name());
            } else {
                subCommand.handleSubcommand(cmdCtx, parsedCommand);
            }
        } else {
            this.displayHelp(cmdCtx, ConnectionStoreOptions.Symbol.CONNMGR.name());
            for (String errorMessage : errorMessages) {
                cmdCtx.getMessageLogger().logUserMessage(errorMessage + "\n");
            }
        }
        return true;
    }

    private void handleImportCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        ctx.getMessageLogger().traceMessage("CONNECTIONS IMPORT");
        String duplicates = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.DUPLICATES);
        ctx.getMessageLogger().traceMessage("Duplicate options = " + duplicates);
        String secretName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.KEY);
        boolean stripPwd = parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.STRIP_PASSWORDS);
        TextSecret secret = null;
        if (stripPwd) {
            secret = TextSecret.none();
            if (secretName != null) {
                ctx.getMessageLogger().logUserMessage("Warning: password stripping overrides provided key");
            }
        } else if (secretName != null) {
            secret = SecretCache.getInstance().findSecret(secretName);
        }
        String path = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.PATH);
        ctx.getMessageLogger().traceMessage("import path = " + path);
        if (!ModelUtil.hasLength(path)) {
            ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.getString("FAILURE_MISSING_FILE"));
            this.displayHelp(ctx, this.createHelpPath(ConnectionStoreOptions.COMMAND.getName(), ConnectionStoreOptions.IMPORT_COMMAND.getName()));
            return;
        }
        Path importPath = FileUtils.getFilePath(ctx.getScriptRunnerContext(), path);
        if (importPath == null) {
            ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("FAILURE_FILE_NOT_FOUND", path));
            return;
        }
        Collection<ImportedConnectionResult> connections = ImporterFactory.getImporter(importPath, ConnectionStoreOptions.DuplicatesPolicy.valueOf(duplicates.toUpperCase()), NamedConnections.instance().listConnections(), ctx, secret).importConnections();
        connections.forEach(p -> ((ImportedConnectionResult)p).logResult(ctx.getMessageLogger()));
        ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("IMPORT_CONNECTIONS_COUNT", connections.size()));
        NamedConnections.refresh();
    }

    private void handleListCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        NamedConnections.instance().listConnections().forEach(arg_0 -> ((MessageLogger)ctx.getMessageLogger()).logUserMessage(arg_0));
    }

    private void handleShowCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        String cName = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.CONNECTION_NAME);
        ctx.getMessageLogger().traceMessage("Connection name: " + cName);
        ConnectionDetailDisplay.instance().displayConnectionDetails(ctx, cName);
    }

    private void handleTestCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        ConnectionDefinition definition;
        String cName = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.CONNECTION_NAME);
        ctx.getMessageLogger().traceMessage("Connection name: " + cName);
        String user = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.USERNAME);
        if (user != null) {
            ctx.getMessageLogger().traceMessage("Override username with " + user);
        }
        if ((definition = ConnectionStoreCommand.getConnectionDefinition(cName, ctx)) == null) {
            return;
        }
        ConnectionHelper creator = ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)definition, (MessageLogger)ctx.getMessageLogger()));
        try {
            ConnectionTester tester = ConnectionTester.builder(definition).messageLogger(ctx.getMessageLogger()).scriptRunnerContext(ctx.getScriptRunnerContext()).build();
            tester.testConnection(user);
            ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.getString("TEST_SUCCESS"));
        }
        catch (SQLException ex) {
            ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("TEST_FAILURE", ex.getLocalizedMessage()));
        }
    }

    private void handleCloneCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        block3: {
            try {
                SQLclConnectionCloner.Builder builder = SQLclConnectionCloner.builder(ctx);
                String origName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.ORIGINAL);
                ConnectionDefinition origDef = ConnectionStoreCommand.getConnectionDefinition(origName, ctx);
                builder.origin(origDef);
                String dest = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.CONNECTION_NAME);
                builder.destination(dest);
                SQLclConnectionCloner cloner = builder.build();
                cloner.cloneConnection();
                String username = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.USERNAME);
                boolean skipPwd = parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.NOPWD);
                if (ModelUtil.hasLength(username)) {
                    cloner.updateUser(username, !skipPwd);
                }
                cloner.saveConnection();
                NamedConnections.refresh();
            }
            catch (IOException ex) {
                ctx.getMessageLogger().logUserMessage(ex.getLocalizedMessage());
                Throwable cause = ex.getCause();
                if (cause == null) break block3;
                ctx.getMessageLogger().logUserMessage(cause.toString());
            }
        }
    }

    static ConnectionDefinition getConnectionDefinition(String cName, CommandContext cmdCtx) {
        Connections.Identifier ci = NamedConnections.instance().lookupConnectionIdentifier(cName);
        if (ci == null) {
            cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("ERROR_UNKNOWN_CONNECTION", cName));
            return null;
        }
        ConnectionDefinition definition = NamedConnections.instance().getConnectionDefinition(ci);
        if (definition == null) {
            cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("ERROR_LOADING_CONNECTION", cName));
            return null;
        }
        return definition;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    private static interface SubCommand {
        public void handleSubcommand(CommandContext var1, ParsedCommand var2);
    }
}

