/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.DrawSelectionUtil;
import ilog.views.IlvApplyObject;
import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IlvReshapeSelection2
extends IlvObjectInteractor {
    private IlvObjectInteractorContext _lastContext;
    private IlvTransformer _lastTransformer;
    private final IlvRect _trackRect = new IlvRect();
    private int _resizeDirection;
    private IlvRect _originalBBox;
    private IlvPoint _movePoint = new IlvPoint(0.0f, 0.0f);
    private boolean _initiated = false;
    private float _dsOldMinimumSize;
    private float _aspect = -1.0f;
    private boolean _isOpaqueMode = false;
    private int _cursorDirection = 0;
    private Cursor _lastCursor = Cursor.getDefaultCursor();
    private static final float NO_ASPECT = -1.0f;

    public Cursor getCursor(int direction) {
        return IlvUtil.CursorFromDirection((int)direction);
    }

    protected void reshape(IlvGraphic graphic, IlvObjectInteractorContext context, IlvPoint trackPoint) {
        this.reshapeIfRequired(graphic, context);
        this.reshapeAdjust(graphic, context, trackPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reshapeObject(IlvGraphic graphic, IlvRect rect) {
        IlvGraphicBag bag = graphic.getGraphicBag();
        IlvGraphicBag ilvgraphicbag1 = graphic.getTopLevelGraphicBag();
        IlvManager manager = null;
        if (ilvgraphicbag1 != bag && ilvgraphicbag1 != null) {
            manager = (IlvManager)ilvgraphicbag1;
            manager.setContentsAdjusting(true);
        }
        try {
            bag.reshapeObject(graphic, rect, true);
        }
        finally {
            if (manager != null) {
                manager.setContentsAdjusting(false);
            }
        }
    }

    protected boolean handleButtonDown(IlvDrawSelection ds, MouseEvent event, IlvObjectInteractorContext context) {
        if ((event.getModifiers() & 8) != 0 || (event.getModifiers() & 4) != 0) {
            return true;
        }
        if (this._initiated) {
            return true;
        }
        if (!ds.supportsResize()) {
            this._initiated = false;
            return true;
        }
        IlvPoint point = new IlvPoint((float)event.getX(), (float)event.getY());
        IlvTransformer tx = context.getTransformer();
        this._resizeDirection = ds.direction(point, tx);
        if (this._resizeDirection == 0) {
            return false;
        }
        if (this.shouldVetoReshape(ds, context)) {
            this._initiated = false;
            return true;
        }
        this._initiated = true;
        IlvGraphic graphic = ds.getObject();
        this.reshapeInitiated(ds, context);
        this.initializeTracking(graphic, context);
        this._trackRect.reshape(this._originalBBox.x, this._originalBBox.y, this._originalBBox.width, this._originalBBox.height);
        this._aspect = -1.0f;
        if (graphic instanceof IlvManager && ((IlvManager)graphic).isKeepingAspectRatio()) {
            IlvRect rect = this.getBoundingBox(graphic, null);
            if (rect.width >= 1.0f && rect.height >= 1.0f) {
                this._aspect = rect.width / rect.height;
            }
        }
        if (this.isOpaqueMode()) {
            this._dsOldMinimumSize = DrawSelectionUtil.getMinimumSize(ds);
            this.setDrawSelectionMinimumSize(ds, 0.0f);
        } else {
            this.repaint(graphic, context);
        }
        this._cursorDirection = 0;
        this._lastCursor = context.getCursor();
        this.updateCursor(context, this._resizeDirection);
        return true;
    }

    protected IlvRect getBoundingBox(IlvGraphic graphic, IlvTransformer tx) {
        return graphic.boundingBox(tx);
    }

    public void setOpaqueMode(boolean opaque) {
        this._isOpaqueMode = opaque;
    }

    public boolean isOpaqueMode() {
        return this._isOpaqueMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processEvent(IlvGraphic graphic, AWTEvent awtevent, IlvObjectInteractorContext context) {
        try {
            if (this._lastTransformer != null) {
                this._lastTransformer.inverse(this._trackRect);
                if (this._originalBBox != null) {
                    this._lastTransformer.inverse(this._originalBBox);
                }
                if (this._movePoint != null) {
                    this._lastTransformer.inverse(this._movePoint);
                }
            }
            this._lastContext = context;
            if (this._lastContext != null) {
                this._lastTransformer = new IlvTransformer(this._lastContext.getTransformer());
                this._lastTransformer.apply(this._trackRect);
                if (this._originalBBox != null) {
                    this._lastTransformer.apply(this._originalBBox);
                }
                if (this._movePoint != null) {
                    this._lastTransformer.apply(this._movePoint);
                }
            }
            if (!(graphic instanceof IlvDrawSelection)) {
                boolean bl = false;
                return bl;
            }
            switch (awtevent.getID()) {
                case 501: {
                    boolean bl = this.handleButtonDown((IlvDrawSelection)graphic, (MouseEvent)awtevent, context);
                    return bl;
                }
                case 506: {
                    boolean bl = this.handleButtonDragged((IlvDrawSelection)graphic, (MouseEvent)awtevent, context);
                    return bl;
                }
                case 502: {
                    boolean bl = this.handleButtonUp((IlvDrawSelection)graphic, (MouseEvent)awtevent, context);
                    return bl;
                }
                case 401: {
                    boolean bl = this.handleKeyPressed((IlvDrawSelection)graphic, (KeyEvent)awtevent, context);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._lastContext = null;
        }
    }

    protected boolean handleKeyPressed(IlvDrawSelection sel, KeyEvent keyEvent, IlvObjectInteractorContext context) {
        if (this._initiated && this.isAbortEvent(sel, keyEvent, context)) {
            this.abortReshape(sel, keyEvent, context);
            return true;
        }
        return false;
    }

    protected void abortReshape(IlvDrawSelection sel, KeyEvent keyEvent, IlvObjectInteractorContext context) {
        IlvGraphic shape = sel.getObject();
        if (this.isOpaqueMode() && shape != null) {
            IlvTransformer tx = context.getTransformer();
            IlvRect originalRect = new IlvRect(this._originalBBox);
            if (tx != null) {
                tx.inverse(originalRect);
            }
            this.reshapeObject(shape, originalRect);
        }
        this._initiated = false;
        context.setCursor(this._lastCursor);
        this._cursorDirection = 0;
    }

    protected boolean isAbortEvent(IlvDrawSelection sel, KeyEvent keyEvent, IlvObjectInteractorContext context) {
        return false;
    }

    public void handleExpose(IlvGraphic graphic, Graphics g, IlvObjectInteractorContext context) {
        if (!this.isOpaqueMode() && graphic instanceof IlvDrawSelection) {
            this.drawGhost((IlvDrawSelection)graphic, g, context);
        }
    }

    protected final IlvObjectInteractorContext getLastContext() {
        return this._lastContext;
    }

    protected final void setOriginalBoundingBox(IlvRect bbox) {
        this._originalBBox = bbox;
        switch (this._resizeDirection) {
            case 5: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width, this._originalBBox.y + this._originalBBox.height);
                break;
            }
            case 9: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width, this._originalBBox.y);
                break;
            }
            case 6: {
                this._movePoint.move(this._originalBBox.x, this._originalBBox.y + this._originalBBox.height);
                break;
            }
            case 10: {
                this._movePoint.move(this._originalBBox.x, this._originalBBox.y);
                break;
            }
            case 4: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width / 2.0f, this._originalBBox.y + this._originalBBox.height);
                break;
            }
            case 8: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width / 2.0f, this._originalBBox.y);
                break;
            }
            case 1: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width, this._originalBBox.y + this._originalBBox.height / 2.0f);
                break;
            }
            case 2: {
                this._movePoint.move(this._originalBBox.x, this._originalBBox.y + this._originalBBox.height / 2.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleButtonDragged(IlvDrawSelection ds, MouseEvent event, IlvObjectInteractorContext context) {
        if (!this._initiated) {
            return false;
        }
        boolean opaque = this.isOpaqueMode();
        IlvGraphic graphic = ds.getObject();
        if (!opaque) {
            this.repaint(graphic, context);
        }
        IlvPoint point = new IlvPoint((float)event.getX(), (float)event.getY());
        IlvTransformer tx = context.getTransformer();
        IlvPoint ilvpoint1 = new IlvPoint(point);
        context.snapToGrid(point);
        this.updateCursor(context, point);
        switch (this._resizeDirection) {
            case 4: 
            case 8: {
                this._trackRect.move(this._originalBBox.x, Math.min(this._movePoint.y, point.y));
                this._trackRect.resize(this._originalBBox.width, Math.max(this._movePoint.y, point.y) - this._trackRect.y);
                break;
            }
            case 1: 
            case 2: {
                this._trackRect.move(Math.min(this._movePoint.x, point.x), this._originalBBox.y);
                this._trackRect.resize(Math.max(this._movePoint.x, point.x) - this._trackRect.x, this._originalBBox.height);
                break;
            }
            default: {
                this._trackRect.move(Math.min(this._movePoint.x, point.x), Math.min(this._movePoint.y, point.y));
                this._trackRect.resize(Math.max(this._movePoint.x, point.x) - this._trackRect.x, Math.max(this._movePoint.y, point.y) - this._trackRect.y);
            }
        }
        if (this.isKeepingAspectRatio()) {
            this._trackRect.width = Math.max(this._trackRect.width, this._trackRect.height * this._aspect);
            this._trackRect.height = Math.max(this._trackRect.height, this._trackRect.width / this._aspect);
            switch (this.getMouseAdjustmentDirection(point)) {
                case 4: 
                case 6: {
                    this._trackRect.y = this._movePoint.y - this._trackRect.height;
                    break;
                }
                case 1: 
                case 9: {
                    this._trackRect.x = this._movePoint.x - this._trackRect.width;
                    break;
                }
                case 5: {
                    this._trackRect.x = this._movePoint.x - this._trackRect.width;
                    this._trackRect.y = this._movePoint.y - this._trackRect.height;
                }
            }
        }
        if (this._trackRect.width < 1.0f) {
            if (ilvpoint1.x < this._movePoint.x) {
                this._trackRect.x = this._movePoint.x - 1.0f;
                this._trackRect.width = 1.0f;
                point.x = this._trackRect.x;
            } else {
                this._trackRect.width = 1.0f;
                point.x = this._trackRect.x + this._trackRect.width;
            }
        }
        if (this._trackRect.height < 1.0f) {
            if (ilvpoint1.y < this._movePoint.y) {
                this._trackRect.y = this._movePoint.y - 1.0f;
                this._trackRect.height = 1.0f;
                point.y = this._trackRect.y;
            } else {
                this._trackRect.height = 1.0f;
                point.y = this._trackRect.y + this._trackRect.height;
            }
        }
        if (tx != null) {
            tx.inverse(this._trackRect);
            tx.inverse(this._originalBBox);
            tx.inverse(this._movePoint);
        }
        try {
            context.ensureVisible(point);
        }
        finally {
            tx = context.getTransformer();
            if (tx != null) {
                tx.apply(this._trackRect);
                tx.apply(this._originalBBox);
                tx.apply(this._movePoint);
            }
        }
        if (opaque) {
            this.reshape(graphic, context, point);
        } else {
            this.repaint(graphic, context);
        }
        return true;
    }

    protected boolean handleButtonUp(IlvDrawSelection ds, MouseEvent event, IlvObjectInteractorContext context) {
        if (!this._initiated) {
            return true;
        }
        this._initiated = false;
        IlvGraphic graphic = ds.getObject();
        boolean opaque = this.isOpaqueMode();
        if (opaque) {
            this.setDrawSelectionMinimumSize(ds, this._dsOldMinimumSize);
        } else {
            this.repaint(graphic, context);
        }
        IlvPoint point = new IlvPoint((float)event.getX(), (float)event.getY());
        this.reshape(graphic, context, point);
        context.setCursor(this._lastCursor);
        this._cursorDirection = 0;
        this.reshapeComplete(ds, context);
        return true;
    }

    private boolean reshapeIfRequired(IlvGraphic graphic, IlvObjectInteractorContext context) {
        IlvRect rect = new IlvRect(this._trackRect);
        rect.height = Math.max(rect.height, 1.0f);
        rect.width = Math.max(rect.width, 1.0f);
        IlvTransformer tx = context.getTransformer();
        if (tx != null) {
            tx.inverse(rect);
        }
        if (rect.width < 1.0E-20f || rect.height < 1.0E-20f) {
            return false;
        }
        this.reshapeObject(graphic, rect);
        return true;
    }

    private void initializeTracking(IlvGraphic graphic, IlvObjectInteractorContext context) {
        IlvTransformer tx = context.getTransformer();
        this._originalBBox = this.getBoundingBox(graphic, tx);
        switch (this._resizeDirection) {
            case 5: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width, this._originalBBox.y + this._originalBBox.height);
                break;
            }
            case 9: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width, this._originalBBox.y);
                break;
            }
            case 6: {
                this._movePoint.move(this._originalBBox.x, this._originalBBox.y + this._originalBBox.height);
                break;
            }
            case 10: {
                this._movePoint.move(this._originalBBox.x, this._originalBBox.y);
                break;
            }
            case 4: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width / 2.0f, this._originalBBox.y + this._originalBBox.height);
                break;
            }
            case 8: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width / 2.0f, this._originalBBox.y);
                break;
            }
            case 1: {
                this._movePoint.move(this._originalBBox.x + this._originalBBox.width, this._originalBBox.y + this._originalBBox.height / 2.0f);
                break;
            }
            case 2: {
                this._movePoint.move(this._originalBBox.x, this._originalBBox.y + this._originalBBox.height / 2.0f);
            }
        }
    }

    private int getMouseAdjustmentDirection(IlvPoint point) {
        int direction = this._resizeDirection;
        switch (direction) {
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                if (point.x < this._movePoint.x) {
                    if (point.y < this._movePoint.y) {
                        direction = 5;
                        break;
                    }
                    direction = 9;
                    break;
                }
                if (point.y < this._movePoint.y) {
                    direction = 6;
                    break;
                }
                direction = 10;
                break;
            }
            case 4: 
            case 8: {
                if (point.y < this._movePoint.y) {
                    direction = 4;
                    break;
                }
                direction = 8;
                break;
            }
            case 1: 
            case 2: {
                direction = point.x < this._movePoint.x ? 1 : 2;
            }
        }
        return direction;
    }

    private void reshapeAdjust(IlvGraphic graphic, IlvObjectInteractorContext context, IlvPoint point) {
        IlvTransformer tx = context.getTransformer();
        IlvPoint ilvpoint1 = new IlvPoint(this._movePoint);
        IlvRect rect = this.getBoundingBox(graphic, tx);
        boolean adjust = false;
        int direction = this.getMouseAdjustmentDirection(point);
        switch (direction) {
            case 5: {
                adjust = rect.x != ilvpoint1.x - rect.width || rect.y != ilvpoint1.y - rect.height;
                rect.x = ilvpoint1.x - rect.width;
                rect.y = ilvpoint1.y - rect.height;
                break;
            }
            case 9: {
                adjust = rect.x != ilvpoint1.x - rect.width || rect.y != ilvpoint1.y;
                rect.x = ilvpoint1.x - rect.width;
                rect.y = ilvpoint1.y;
                break;
            }
            case 6: {
                adjust = rect.x != ilvpoint1.x || rect.y != ilvpoint1.y - rect.height;
                rect.x = ilvpoint1.x;
                rect.y = ilvpoint1.y - rect.height;
                break;
            }
            case 10: {
                adjust = rect.x != ilvpoint1.x || rect.y != ilvpoint1.y;
                rect.x = ilvpoint1.x;
                rect.y = ilvpoint1.y;
                break;
            }
            case 4: {
                adjust = rect.y != ilvpoint1.y - rect.height;
                rect.y = ilvpoint1.y - rect.height;
                break;
            }
            case 8: {
                adjust = rect.y != ilvpoint1.y;
                rect.y = ilvpoint1.y;
                break;
            }
            case 1: {
                adjust = rect.x != ilvpoint1.x - rect.width;
                rect.x = ilvpoint1.x - rect.width;
                break;
            }
            case 2: {
                adjust = rect.x != ilvpoint1.x;
                rect.x = ilvpoint1.x;
            }
        }
        if (adjust) {
            if (tx != null) {
                tx.inverse(rect);
            }
            this.reshapeObject(graphic, rect);
        }
    }

    private void setDrawSelectionMinimumSize(IlvDrawSelection ds, float minimum) {
        if (DrawSelectionUtil.getMinimumSize(ds) != minimum) {
            IlvGraphicBag bag = ds.getGraphicBag();
            if (bag == null) {
                DrawSelectionUtil.setMinimumSize(ds, minimum);
            } else {
                bag.applyToObject((IlvGraphic)ds, new IlvApplyObject(){

                    public void apply(IlvGraphic graphic, Object obj) {
                        ((IlvDrawSelection)graphic).a(((Float)obj).floatValue());
                    }
                }, (Object)Float.valueOf(minimum), true);
            }
        }
    }

    private void updateCursor(IlvObjectInteractorContext context, IlvPoint point) {
        float dx = point.x - this._movePoint.x;
        float dy = point.y - this._movePoint.y;
        switch (this._resizeDirection) {
            case 4: {
                if (dy > 0.0f) {
                    this.updateCursor(context, 8);
                    break;
                }
                this.updateCursor(context, 4);
                break;
            }
            case 8: {
                if (dy < 0.0f) {
                    this.updateCursor(context, 4);
                    break;
                }
                this.updateCursor(context, 8);
                break;
            }
            case 1: {
                if (dx > 0.0f) {
                    this.updateCursor(context, 2);
                    break;
                }
                this.updateCursor(context, 1);
                break;
            }
            case 2: {
                if (dx < 0.0f) {
                    this.updateCursor(context, 1);
                    break;
                }
                this.updateCursor(context, 2);
                break;
            }
            case 5: {
                if (dx > 0.0f && dy > 0.0f) {
                    this.updateCursor(context, 10);
                    break;
                }
                if (dx > 0.0f) {
                    this.updateCursor(context, 6);
                    break;
                }
                if (dy > 0.0f) {
                    this.updateCursor(context, 9);
                    break;
                }
                this.updateCursor(context, 5);
                break;
            }
            case 6: {
                if (dx < 0.0f && dy > 0.0f) {
                    this.updateCursor(context, 9);
                    break;
                }
                if (dx < 0.0f) {
                    this.updateCursor(context, 5);
                    break;
                }
                if (dy > 0.0f) {
                    this.updateCursor(context, 10);
                    break;
                }
                this.updateCursor(context, 6);
                break;
            }
            case 9: {
                if (dx > 0.0f && dy < 0.0f) {
                    this.updateCursor(context, 6);
                    break;
                }
                if (dx > 0.0f) {
                    this.updateCursor(context, 10);
                    break;
                }
                if (dy < 0.0f) {
                    this.updateCursor(context, 5);
                    break;
                }
                this.updateCursor(context, 9);
                break;
            }
            case 10: {
                if (dx < 0.0f && dy < 0.0f) {
                    this.updateCursor(context, 5);
                    break;
                }
                if (dx < 0.0f) {
                    this.updateCursor(context, 9);
                    break;
                }
                if (dy < 0.0f) {
                    this.updateCursor(context, 6);
                    break;
                }
                this.updateCursor(context, 10);
            }
        }
    }

    private void updateCursor(IlvObjectInteractorContext context, int direction) {
        if (this._cursorDirection != direction) {
            context.setCursor(this.getCursor(direction));
            this._cursorDirection = direction;
        }
    }

    private void repaint(IlvGraphic g, IlvObjectInteractorContext context) {
        if (this.isOpaqueMode() || g == null || context == null) {
            return;
        }
        if (this._trackRect == null || this._trackRect.width == 0.0f || this._trackRect.height == 0.0f) {
            return;
        }
        IlvRect rect = new IlvRect(this._trackRect);
        context.repaint(rect);
    }

    protected void drawGhost(IlvDrawSelection ds, Graphics g1, IlvObjectInteractorContext context) {
        if (!this.isOpaqueMode()) {
            g1.setColor(context.getDefaultGhostColor());
            g1.setXORMode(context.getDefaultXORColor());
            g1.drawRect((int)Math.floor(this._trackRect.x), (int)Math.floor(this._trackRect.y), (int)Math.floor(this._trackRect.width), (int)Math.floor(this._trackRect.height));
        }
    }

    private boolean isKeepingAspectRatio() {
        return this._aspect > 0.0f;
    }

    protected boolean shouldVetoReshape(IlvDrawSelection ds, IlvObjectInteractorContext context) {
        return false;
    }

    protected void reshapeInitiated(IlvDrawSelection ds, IlvObjectInteractorContext context) {
    }

    protected void reshapeComplete(IlvDrawSelection ds, IlvObjectInteractorContext context) {
    }
}

