/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.template.TemplateData;
import oracle.jdeveloper.template.TemplateProfileInfo;
import oracle.jdevimpl.deploy.dt.gallery.ProfileElementsProvider;

public abstract class AbstractTemplate
extends HashStructureAdapter
implements Comparable,
Element {
    static final String TEMPLATE_NAME = "name";
    static final String TEMPLATE_ID = "templateId";
    static final String DESCRIPTION = "description";
    static final String TOOLTIP = "toolTip";
    static final String ICON = "icon";
    static final String UNSORTED = "unsorted";
    static final String GALLERY_FOLDER = "galleryFolder";
    static final String PACKAGE_NAME = "packageName";
    static final String TECHNOLOGY_SCOPE = "technologyScope";
    static final String TECHNOLOGY_KEY = "technologyKey";
    static final String DEPLOYMENT_PROFILE = "deploymentProfile";
    static final String DEPLOYMENT_PROFILES = "deploymentProfiles";
    static final String CREATION_LISTENER = "creationListener";
    static final String EXCLUDE_FROM_GALLERY = "excludeFromGallery";
    public static final Comparator NAME_COMPARATOR = new TemplateComparator(){

        @Override
        public int compare(AbstractTemplate o1, AbstractTemplate o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    static final String TEMPLATE_CLASS = "templateClass";
    static final String CHILDREN = "nestedTemplates";
    static final String OWNING_EXTENSION_ID = "owningExtensionId";
    private transient Attributes attributes_ = new ElementAttributes();
    protected TemplateData parent_ = null;
    private boolean valid_ = true;
    private boolean defaultTemplate_;

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getTemplateId().hashCode();
    }

    public boolean equals(Object o) {
        AbstractTemplate other;
        String id;
        return o != null && o.getClass() == this.getClass() && ModelUtil.hasLength((String)(id = (other = (AbstractTemplate)o).getTemplateId())) && ModelUtil.hasLength((String)this.getTemplateId()) && id.equals(this.getTemplateId());
    }

    final void setDefaultTemplate(boolean isDefault) {
        this.defaultTemplate_ = isDefault;
    }

    public final boolean isDefaultTemplate() {
        return this.defaultTemplate_;
    }

    protected AbstractTemplate(HashStructure hash) {
        super(hash);
    }

    protected AbstractTemplate() {
        this(HashStructure.newInstance());
    }

    public void initializeFromExtensionHook(HashStructure hash, TemplateData lookup) {
        if (hash.containsKey(TEMPLATE_ID)) {
            this.setTemplateId(this.getTextFromHook(hash, TEMPLATE_ID));
        }
        if (hash.containsKey(TEMPLATE_NAME)) {
            this.setName(this.getTextFromHook(hash, TEMPLATE_NAME));
        }
        if (hash.containsKey(DESCRIPTION)) {
            this.setDescription(this.getTextFromHook(hash, DESCRIPTION));
        }
        if (hash.containsKey(this.getContainerNameKey())) {
            this.setContainerName(this.getTextFromHook(hash, this.getContainerNameKey()));
        }
        if (hash.containsKey(TOOLTIP)) {
            this.setToolTipText(this.getTextFromHook(hash, TOOLTIP));
        }
        if (hash.containsKey(ICON)) {
            this.setIconFile(this.getTextFromHook(hash, ICON));
        }
        if (hash.containsKey(PACKAGE_NAME)) {
            this.setPackageName(this.getTextFromHook(hash, PACKAGE_NAME));
        }
        if (hash.containsKey(UNSORTED)) {
            boolean value = Boolean.TRUE.toString().equalsIgnoreCase(this.getTextFromHook(hash, UNSORTED));
            this.setUnsorted(value);
        }
        if (hash.containsKey(GALLERY_FOLDER)) {
            this.setGalleryFolder(this.getTextFromHook(hash, GALLERY_FOLDER));
        }
        if (hash.containsKey(DEPLOYMENT_PROFILE)) {
            this.setDeploymentProfile(this.getTextFromHook(hash, DEPLOYMENT_PROFILE));
        }
        if (hash.containsKey(DEPLOYMENT_PROFILES)) {
            HashStructure hash0 = hash.getHashStructure(DEPLOYMENT_PROFILES);
            List list = hash0.getAsList(DEPLOYMENT_PROFILE);
            int sz = list.size();
            TemplateProfileInfo[] profileInfos = new TemplateProfileInfo[sz];
            for (int i = 0; i < sz; ++i) {
                profileInfos[i] = new TemplateProfileInfo(HashStructure.newInstance());
                profileInfos[i].initializeFromExtensionHook((HashStructure)list.get(i));
            }
            this.setDeploymentProfiles(profileInfos);
        }
        this.setOwningExtensionId(HashStructureHook.getExtensionId((HashStructure)hash));
        this.setValid(this.validate());
    }

    protected String getTextFromHook(HashStructure hash, String key) {
        return hash.getString(key + "/#text");
    }

    public String getTemplateId() {
        return AbstractTemplate.getTemplateId(this._hash);
    }

    public static String getTemplateId(HashStructure hash) {
        return hash.getString(TEMPLATE_ID);
    }

    public static void setTemplateId(HashStructure hash, String id) {
        hash.putString(TEMPLATE_ID, id);
    }

    public void setTemplateId(String id) {
        AbstractTemplate.setTemplateId(this._hash, id);
    }

    public String getName() {
        return this._hash.getString(TEMPLATE_NAME);
    }

    public void setName(String name) {
        this._hash.putString(TEMPLATE_NAME, name);
    }

    public String getDescription() {
        return this._hash.getString(DESCRIPTION);
    }

    public void setDescription(String desc) {
        this._hash.putString(DESCRIPTION, desc);
    }

    public String getPackageName() {
        return this._hash.getString(PACKAGE_NAME);
    }

    public void setPackageName(String name) {
        this._hash.putString(PACKAGE_NAME, name);
    }

    @Deprecated
    public float getWeight() {
        return 0.0f;
    }

    @Deprecated
    public void setWeight(float weight) {
    }

    @Deprecated
    public String getDeploymentProfile() {
        return this._hash.getString(DEPLOYMENT_PROFILE);
    }

    @Deprecated
    public void setDeploymentProfile(String deploymentProfile) {
        if (deploymentProfile == null) {
            this._hash.remove(DEPLOYMENT_PROFILE);
            return;
        }
        this._hash.putString(DEPLOYMENT_PROFILE, deploymentProfile);
        this.setDeploymentProfiles(null);
    }

    public TemplateProfileInfo[] getDeploymentProfiles() {
        ListStructure list = this._hash.getListStructure(DEPLOYMENT_PROFILES);
        int sz = 0;
        if (list == null || list.isEmpty()) {
            String profileId = this.getDeploymentProfile();
            if (profileId != null) {
                TemplateProfileInfo loneDeploymentProfile = new TemplateProfileInfo(HashStructure.newInstance());
                loneDeploymentProfile.setProfileId(profileId);
                loneDeploymentProfile.setProfileNameFormat(null);
                return new TemplateProfileInfo[]{loneDeploymentProfile};
            }
        } else {
            sz = list.size();
        }
        TemplateProfileInfo[] ret = new TemplateProfileInfo[sz];
        for (int i = 0; i < sz; ++i) {
            ret[i] = new TemplateProfileInfo((HashStructure)list.get(i));
        }
        return ret;
    }

    public void setDeploymentProfiles(TemplateProfileInfo[] profileInfos) {
        if (profileInfos == null) {
            this._hash.remove(DEPLOYMENT_PROFILES);
            return;
        }
        ListStructure list = this._hash.getOrCreateListStructure(DEPLOYMENT_PROFILES);
        list.clear();
        for (TemplateProfileInfo tpi : profileInfos) {
            list.add((Object)tpi.getHashStructure());
        }
        this.setDeploymentProfile(null);
    }

    public final String getOwningExtensionId() {
        return this._hash.getString(OWNING_EXTENSION_ID);
    }

    public void setOwningExtensionId(String id) {
        this._hash.putString(OWNING_EXTENSION_ID, id);
    }

    public String getContainerName() {
        return this._hash.getString(this.getContainerNameKey());
    }

    public void setContainerName(String name) {
        this._hash.putString(this.getContainerNameKey(), name);
    }

    public void setUnsorted(boolean value) {
        this._hash.putBoolean(UNSORTED, value);
    }

    public boolean isUnsorted() {
        return this._hash.getBoolean(UNSORTED);
    }

    public void setGalleryFolder(String category) {
        this._hash.putString(GALLERY_FOLDER, category);
    }

    public String getGalleryFolder() {
        return this._hash.getString(GALLERY_FOLDER);
    }

    String getTemplateClass() {
        return this._hash.getString(TEMPLATE_CLASS);
    }

    public void setTemplateClass(String clazz) {
        this._hash.putString(TEMPLATE_CLASS, clazz);
    }

    protected String getChildTemplatesKey() {
        return CHILDREN;
    }

    protected abstract String getContainerNameKey();

    protected abstract Icon getDefaultIcon();

    public boolean mayHaveChildren() {
        return false;
    }

    public Attributes getAttributes() {
        return this.attributes_;
    }

    public HashStructure getData() {
        return this._hash;
    }

    public String getShortLabel() {
        return this.getName();
    }

    public String getLongLabel() {
        return this.getName();
    }

    public Iterator<Element> getChildren() {
        return Arrays.asList(new Element[0]).iterator();
    }

    public String getIconFile() {
        return this._hash.getString(ICON);
    }

    public Icon getIcon() {
        String iconFile = this.getIconFile();
        Icon icon = null;
        if (ModelUtil.hasLength((String)iconFile)) {
            URL url = null;
            try {
                url = new URL(iconFile);
            }
            catch (MalformedURLException e) {
                url = this.getClass().getResource(iconFile);
            }
            if (url != null) {
                icon = new ImageIcon(url);
            }
            Assert.printStackTrace((icon == null ? 1 : 0) != 0, (String)("Template Icon could not be loaded from " + iconFile));
        }
        icon = icon == null ? this.getDefaultIcon() : icon;
        return icon;
    }

    public void setIconFile(String iconFile) {
        this._hash.putString(ICON, iconFile);
    }

    public String getToolTipText() {
        String toolTip = this._hash.getString(TOOLTIP);
        return toolTip == null ? this.getName() : toolTip;
    }

    public void setToolTipText(String toolTip) {
        this._hash.putString(TOOLTIP, toolTip);
    }

    public void setTemplateData(TemplateData parent) {
        this.parent_ = parent;
    }

    public TemplateData getTemplateData() {
        return this.parent_;
    }

    void printTemplate() {
        Assert.println((String)("---" + this.getClass().getName() + " ---"));
        Assert.println((String)("templateId=" + this.getTemplateId()));
        Assert.println((String)("templateClass=" + this.getTemplateClass()));
        Assert.println((String)("name=" + this.getName()));
        Assert.println((String)("description=" + this.getDescription()));
        Assert.println((String)("deploymentProifle=" + this.getDeploymentProfile()));
        Assert.println((String)("iconFile=" + this.getIconFile()));
        Assert.println((String)("packageName=" + this.getPackageName()));
    }

    public int compareTo(Object o) {
        AbstractTemplate other = (AbstractTemplate)o;
        if (this.isUnsorted() != other.isUnsorted()) {
            return this.isUnsorted() ? -1 : 1;
        }
        if (this.isUnsorted() && other.isUnsorted()) {
            return 0;
        }
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public boolean isValid() {
        return this.valid_;
    }

    protected void setValid(boolean valid) {
        this.valid_ = valid;
    }

    boolean validate() {
        boolean valid = true;
        Iterator<Element> iter = this.getChildren();
        while (iter.hasNext()) {
            AbstractTemplate t = (AbstractTemplate)iter.next();
            if (t.validate()) continue;
            valid = false;
            break;
        }
        if (!valid) {
            return valid;
        }
        String profileId = this.getDeploymentProfile();
        if (profileId != null) {
            valid = ProfileElementsProvider.getGalleryElementInfo((String)profileId) != null;
        }
        return valid;
    }

    class ElementIterator
    implements Iterator<Element> {
        final Iterator iterator_;

        ElementIterator(Iterator iterator) {
            this.iterator_ = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        @Override
        public Element next() {
            return (Element)this.iterator_.next();
        }

        @Override
        public void remove() {
        }
    }

    private static abstract class TemplateComparator
    implements Comparator<AbstractTemplate> {
        private TemplateComparator() {
        }
    }
}

